#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
//layout(line_strip, max_vertices = 15) out;

layout(binding=0, offset=0) uniform atomic_uint ac;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in vec3 origCenter[3];
in vec4 genInfo[3];
in vec4 emitInfo[3];
in vec4 branchInfo[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
//out vec3 colorG;
out vec4 posW;
out vec3 origCenterG;
out vec4 genInfoG;
out vec4 emitInfoG;
out vec4 branchInfoG;
out float alphaG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float g_discardEdgeLen = 50.0;
// uniform float makkara;

layout(binding=0) uniform sampler2D tex;

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}



void main(void) {

//float dgl = g_discardEdgeLen*g_discardEdgeLen*0.8;
//float ad;

//float mad = 0.0;
//vec3 dd = (gl_in[1].gl_Position-gl_in[0].gl_Position).xyz;
//ad = dot(dd,dd)-dgl;
//mad = max(ad,mad);
//dd = (gl_in[2].gl_Position-gl_in[0].gl_Position).xyz;
//ad = dot(dd,dd)-dgl;
//mad = max(ad,mad);

//dd = (gl_in[2].gl_Position-gl_in[1].gl_Position).xyz;
//ad = dot(dd,dd)-dgl;
//mad = max(ad,mad);

//mad = clamp(1.0-mad*10.0, 0.0, 1.0);


//alphaG = mad;

    alphaG = 1.0;
        vec3 controlBase = vec3(0.0);
		
        //	uint counter = atomicCounterIncrement(ac);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);
        for (int i = 0; i < gl_in.length(); ++i) {
                vec4 posex = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);

                posex.xyz -= origCenter[i];
              //  posex = rotateXZ(posex, 0.250);
              //   posex.z


                posex.xyz += origCenter[i];

                gl_Position = posex;

                //gl_Position.xyz -= normal[i]*0.0;
                facePos += origPos[i];
                // gl_Position.xyz -= normal[i]*1.5;
                posW = modelMatrix*gl_Position;
                gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
                normalG = normal[i];
                //colorG = vec3(1.90, 0.92, 0.9925)*0.01*float(gl_PrimitiveIDIn%100);

                vec4 jk = (modelMatrix * vec4(normalG, 0.0));
                normalWSG = jk.xyz;
                normalG = (modelMatrix * vec4(normalG, 0.0)).xyz;

                genInfoG = genInfo[i];
                origCenterG = origCenter[i];

                posG = gl_Position;
             //   controlG = controlBase;
             //   controlG.r = 0.1;
                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                branchInfoG = branchInfo[i];
                emitInfoG = emitInfo[i];
                EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();



}
